% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{changeObjectIntegrityChecking}
\alias{changeObjectIntegrityChecking}
\title{Disable object integrity checking for a \emph{SNPhood} object.}
\usage{
changeObjectIntegrityChecking(SNPhood.o, disable = FALSE, verbose = TRUE)
}
\arguments{
\item{SNPhood.o}{Object of class \code{\linkS4class{SNPhood}}}

\item{disable}{Logical(1). Default FALSE. Disable the object integrity checking?}

\item{verbose}{Logical(1). Default TRUE. Should the verbose mode (i.e., diagnostic messages during execution of the script) be enabled?}
}
\value{
Object of class \code{\linkS4class{SNPhood}} with object integrity checking disabled.
}
\description{
The function \code{changeObjectIntegrityChecking} disables object integrity checking for a \emph{SNPhood} object. 
This might be desired for large objects when the integrity test takes too much time. 
Note, however, that disabling these checks is not recommended.
}
\examples{
data(SNPhood.o, package="SNPhood")
SNPhood.o = changeObjectIntegrityChecking(SNPhood.o, disable = TRUE)
}

