\name{tabulate.pvals}

\alias{tabulate.pvals}

\title{Sums significant P-values for the analyzed regions}

\description{
	Generates a \code{data.frame} with the significance of P-values in the analyzed regions, dividing them into bins.
}

\usage{
tabulate.pvals(input.regions = "all chrs", 
               adjust.method = "BY", 
               bins = c(0.001, 0.005, 0.01, 0.025, 0.05, 0.075, 0.1, 0.2, 1), 
               significance.idx = 8, 
               order.by, 
               decreasing = TRUE, 
               method = c("full", "smooth", "window", "overlap"),
              run.name = "analysis_results")
}

\arguments{
  \item{input.regions}{\code{vector} indicating the dependent regions to be analyzed. Can be defined in four ways:
  	      \code{1) predefined input region: } insert a predefined input region, choices are: 
  	      \dQuote{all chrs}, 
  	      \dQuote{all chrs auto}, 
  	      \dQuote{all arms}, 
  	      \dQuote{all arms auto} 
  	      In the predefined regions \dQuote{all arms} and \dQuote{all arms auto} the arms 13p, 14p, 15p, 21p and 22p 
  	      are left out, because in most studies there are no or few probes in these regions. 
  	      To include them, just make your own vector of arms. 
  	      \code{2) whole chromosome(s): } insert a single chromosome or a list of chromosomes as a 
  	      \code{vector:} 
  	      \code{c(1, 2, 3)}. 
  	      \code{3) chromosome arms: } insert a single chromosome arm  or a list of chromosome arms like 
  	      \code{c("1q", "2p", "2q")}.
  	      \code{4) subregions of a chromosome: } insert a chromosome number followed by the start and end position like 
  	      \code{"chr1:1-1000000"} 
  	      These regions can also be combined, e.g. \code{c("chr1:1-1000000","2q", 3)}.
  	      See \code{\link{integrated.analysis}} for more information.}  
  	      
  
  \item{adjust.method}{Method used to adjust the P-values for multiple testing, see \link[stats:p.adjust]{p.adjust}.
         Default is \dQuote{BY} recommended when copy number is used as dependent data. 
         See \link{SIM} for more information about adjusting P-values.}
     
  \item{bins}{\code{vector} of significance thresholds. This function will calculate 
  the number of features having a P-value lower than the bin.}

  \item{significance.idx}{Index of \dQuote{bins} to use when computing the percentage
   of significant P-values. Defaults to 8 (i.e. the first entry in \dQuote{bins}), in this case 0.20.}
  
  \item{order.by}{Column used for sorting the table. Defaults to "\%" (i.e. the percentage of significant p-values).}
  
  \item{decreasing}{Direction used for sorting. Defaults to TRUE (i.e. highest values on top).}
   
\item{method}{this must be the either full, window, overlap or smooth but the data should generated by the 
         same method in \code{integrated.analysis}.}
		
  \item{run.name}{This must be the same a given to \code{integrated.analysis}}
}


\value{
 Returns a \code{data.frame}. Each row corresponds to a chromosome and has
  as many entries as entries in bins, plus 1. Each entry contains the 
  number of P-values that is smaller or equal to the corresponding entry
  in bins. 
  
  The last entry holds the percentage of P-values that is smaller than or
  equal to the bin identified by \code{significance.idx}.
}

\author{Marten Boetzer, Melle Sieswerda, Renee X. de Menezes  \email{R.X.Menezes@lumc.nl}}

\seealso{
\link{SIM}, 
\link{tabulate.top.dep.features}, 
\link{tabulate.top.indep.features} 
}


\examples{
#first run example(assemble.data)
#and example(integrated.analysis)
tabulate.pvals(input.regions="8q",
		       adjust.method="BY", 
			   bins=c(0.001,0.005,0.01,0.025,0.05,0.075,0.10,0.20,1.0),	
			   run.name="chr8q") 
}
\keyword{misc}

