% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SIMLR_Large_Scale.R
\name{SIMLR_Large_Scale}
\alias{SIMLR_Large_Scale}
\title{SIMLR Large Scale}
\usage{
SIMLR_Large_Scale(X, c, k = 10, kk = 100, if.impute = FALSE, normalize = FALSE)
}
\arguments{
\item{X}{an (m x n) data matrix of gene expression measurements of individual cells or
and object of class SCESet}

\item{c}{number of clusters to be estimated over X}

\item{k}{tuning parameter}

\item{kk}{number of principal components to be assessed in the PCA}

\item{if.impute}{should I traspose the input data?}

\item{normalize}{should I normalize the input data?}
}
\value{
clusters the cells based on SIMLR Large Scale and their similarities

list of 8 elements describing the clusters obtained by SIMLR, of which y are the resulting clusters: 
	y = results of k-means clusterings,
 	S0 = similarities computed by SIMLR, 
 	F = results from the large scale iterative procedure, 
 	ydata = data referring the the results by k-means,
 	alphaK = clustering coefficients,
 	val = distances from the k-nearest neighbour search,
     ind = indeces from the k-nearest neighbour search,
 	execution.time = execution time of the present run
}
\description{
perform the SIMLR clustering algorithm for large scale datasets
}
\examples{
data(ZeiselAmit)
resized = ZeiselAmit$in_X[, 1:340]
\donttest{
SIMLR_Large_Scale(X = resized, c = ZeiselAmit$n_clust, k = 5, kk = 5)
}

}
