%% getPeakScore function %%
\name{getPeakScore}
\alias{getPeakScore}

\title{Calculate the similarity score for all peaks}

\description{This function calculates and output the similarity scores based on spectral matching and RI similarity for multiple peaks.}

\usage{
getPeakScore(runPeaks = list(), deltaRI = 20, weight = 2/3, plot = FALSE)
}

%- maybe also 'usage' for other objects documented here.
\arguments{
    \item{runPeaks}{a list of peaks of runs, e.g. generated by calling \code{getPeak}.}
    
    \item{deltaRI}{a numeric value for the penalty on the retention index similarity score}

    \item{weight}{a numeric value in [0,1] to calculated a combined weighted similarity scores based on Apex and area under EIC curve.}
    
    \item{plot}{a logical value to generate the histogram of the scores, default is \code{FALSE}.}
}

\details{By calling getScore(), this function calculates the similarity score for multiple peaks in multiple runs. This is performed by using spectral and retention index information together.
}

\value{a matrix of scores with rows as compounds and columns as runs}

\seealso{\code{\link{getScore}}}

\references{\url{http://omics.georgetown.edu/SIMAT.html}}

\author{Mo R. Nezami Ranjbar}

\examples{
    # load an RData file including a single run data acquired by readCDF
    data("Run")
    
    # load targets information
    data(Targets)
    
    # get all the corresponding peaks of the target list
    runPeaks <- getPeak(Run = Run, Targets = Targets)

    # get the scores for all analytes in all runs
    Scores <- getPeakScore(runPeaks = runPeaks)
}