% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/features-filter.R
\name{processTerminalExons}
\alias{processTerminalExons}
\title{Process predicted terminal exons}
\usage{
processTerminalExons(features, min_overhang = NA)
}
\arguments{
\item{features}{\code{TxFeatures} object}

\item{min_overhang}{Minimum overhang required to suppress filtering or
trimming of predicted terminal exons (see Details). Use \code{NA} to
exclude all terminal exons sharing a splice with an internal exon
and trim all remaining terminal exons overlapping other exons.}
}
\value{
\code{TxFeatures} object with processed features
}
\description{
Predicted terminal exons are processed as described under Details.
}
\details{
Processing of terminal exon predictions is done in two steps:
(1) terminal exons that share a splice site with an internal exon are
filtered, and (2) remaining terminal exons that overlap other exons
are trimmed.

\code{predictTxFeatures} predicts flanking terminal exons for each
identified splice junction. This ensures that each splice junction
has a flanking exon after merging with \code{mergeTxFeatures}.
This approach results in many predicted terminal exons that
share a splice site with predicted internal exons (often contained
within them or with a short overhang due to incorrect alignments).
Most of these are not real terminal exons and are filtered before
further analysis. Filtering based on the overhang is controlled with
argument \code{min_overhang}.

Some of the remaining predicted terminal exons overlap other exons
such that their unspliced boundary shows a short overhang with
respect to a spliced boundary of the overlapping exon. Often these
exon extensions into an intron are due to incorrect alignments.
Terminal exons with overhang smaller than \code{min_overhang} are
trimmed such that their trimmmed unspliced boundary coincides with
the spliced boundary of the overlapping exon.
}
\examples{
txf_processed <- processTerminalExons(txf_ann)
}
\author{
Leonard Goldstein
}
