% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plotCoverage}
\alias{plotCoverage}
\title{Plot read coverage and splice junction read counts}
\usage{
plotCoverage(x, geneID = NULL, geneName = NULL, eventID = NULL,
  which = NULL, sample_info = NULL, sizefactor = NA, toscale = c("exon",
  "none", "gene"), color = "darkblue", ylim = NULL, label = NULL,
  nbin = 200, summary = mean, curvature = 1, main = NULL,
  min_anchor = 1, cores = 1)
}
\arguments{
\item{x}{\code{SGFeatureCounts} or \code{SGFeatures} object.
If \code{x} is an \code{SGFeatureCounts} object that includes
multiple samples, average coverage and splice junction counts
are obtained.}

\item{geneID}{Single gene identifier used to subset \code{x}}

\item{geneName}{Single gene name used to subset \code{x}}

\item{eventID}{Single event identifier used to subset \code{x}}

\item{which}{\code{GRanges} used to subset \code{x}}

\item{sample_info}{Data frame with sample information.
If \code{x} is an \code{SGFeatureCounts} object, sample information
is obtained from \code{colData(x)}. If \code{sample_info} includes
multiple samples, average coverage and splice junction counts
are obtained.}

\item{sizefactor}{Numeric vector with length equal to the number of
samples in \code{sample_info}. Used to scale coverages and splice
junction counts before plotting, or before averaging across samples.
Set to \code{NA} to disable scaling. If \code{NULL}, size factors
are calculated as the number of bases sequenced (the product of library
size and average number of bases sequenced per read or fragment),
plotted coverages and splice junction counts are per 1 billion
sequenced bases.}

\item{toscale}{Controls which parts of the splice graph are drawn to
scale. Possible values are \dQuote{none} (exonic and intronic regions
have constant length), \dQuote{exon} (exonic regions are drawn to scale)
and \dQuote{gene} (both exonic and intronic regions are drawn to scale).}

\item{color}{Color used for plotting coverages}

\item{ylim}{Numeric vector of length two, determining y-axis range used
for plotting coverages.}

\item{label}{Optional y-axis label}

\item{nbin}{Number of bins for plotting coverages}

\item{summary}{Function used to calculate per-bin coverage summaries}

\item{curvature}{Numeric determining curvature of plotted splice junctions.}

\item{main}{Plot title}

\item{min_anchor}{Integer specifiying minimum anchor length}

\item{cores}{Number of cores available for parallel processing.}
}
\value{
\code{data.frame} with information on splice junctions included
  in the splice graph
}
\description{
Plot read coverage and splice junction read counts for an individual
sample or averaged across samples.
}
\examples{
\dontrun{
par(mfrow = c(4, 1))
for (j in seq_len(4)) plotCoverage(sgfc_pred[, j])
}
NULL
}
\author{
Leonard Goldstein
}
