% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svacor.R
\name{svacor}
\alias{svacor}
\title{svacor}
\usage{
svacor(
  SE,
  form,
  form0 = ~1,
  assayName = NULL,
  regressOutNull = TRUE,
  method = c("vst", "svaseq", "sva"),
  useVST = NULL,
  n.sv = NULL,
  ...
)
}
\arguments{
\item{SE}{An object of class `SummarizedExperiment`.}

\item{form}{The formula of the differential expression model}

\item{form0}{An optional formula for the null model}

\item{assayName}{The name (or index) of the assay to use.}

\item{regressOutNull}{Logical; whether to regress out the variables of `form0`.}

\item{method}{Either 'vst' (uses DESeq2 variance-stabilization before
running SVA), 'svaseq' (uses sva::svaseq on normalized counts), or 'sva'
(uses standard sva, not appropriate for count data).}

\item{useVST}{Deprecated; use the `method` argument instead.}

\item{n.sv}{The number of surrogate variables (if omitted, \code{\link{sva}}
will attempt to estimate it). Note that automatic determination of the number
of SVs will often lead to fairly large number of SVs, use
`numSVmethod="leek"` for a more conservative estimate.}

\item{...}{Any other argument passed to the \code{\link{sva}} command.}
}
\value{
Returns the `SummarizedExperiment` with a `corrrected` assay and the
surrogate variables in `colData`.
}
\description{
A wrapper around SVA-based correction, providing a corrected assay. If this
is RNAseq data or similar, use a count assay assay with `method` either 'vst'
or 'svaseq'; otherwise (e.g. proteomics) a log-normalized assay is
recommended with `method="sva"`. Note that the corrected assay, while useful
for visualization, should be interpreted with care, as they omit major
variation!
}
\examples{
data("SE", package="SEtools")
SE <- svacor(SE, ~Condition)
}
