set.seed(617)

test_that("PCA returns expected output structure", {
  counts_mat <- matrix(rpois(30, 10), ncol = 3)
  x <- setaTransform(counts_mat, method = "CLR")
  res <- setaLatent(x, method = "PCA", dims = 2)
  expect_type(res, "list")
  expect_identical(res$method, "PCA")
  expect_s3_class(res$latentSpace, "data.frame")
  expect_s3_class(res$loadings, "data.frame")
  expect_length(res$varExplained, 2)
})

test_that("PCoA returns expected output structure", {
  counts_mat <- matrix(rpois(30, 10), ncol = 3)
  x <- setaTransform(counts_mat, method = "CLR")
  res <- setaLatent(x, method = "PCoA", dims = 2)
  expect_type(res, "list")
  expect_identical(res$method, "PCoA")
  expect_s3_class(res$latentSpace, "data.frame")
  expect_true(is.na(res$loadings))
  expect_true(length(res$varExplained) >= 1)
})

test_that("NMDS returns expected output structure", {
  counts_mat <- matrix(rpois(30, 10), ncol = 3)
  x <- setaTransform(counts_mat, method = "CLR")
  res <- setaLatent(x, method = "NMDS", dims = 2)
  expect_type(res, "list")
  expect_identical(res$method, "NMDS")
  expect_s3_class(res$latentSpace, "data.frame")
  expect_true(is.na(res$loadings))
  expect_s3_class(res$varExplained, "data.frame")
  expect_named(res$varExplained, "Stress")
})