% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transforms.R
\name{setaALR}
\alias{setaALR}
\title{Additive Log-Ratio (ALR) Transform}
\usage{
setaALR(counts, ref, pseudocount = 1)
}
\arguments{
\item{counts}{A numeric matrix with rows as samples and columns as taxa.}

\item{ref}{Either the reference taxon name (a character string, which must
appear in \code{colnames(counts)}) or the column index of the reference.}

\item{pseudocount}{Numeric. Added to every count to avoid \code{log(0)}.
Default is 1.}
}
\value{
A list with:
\describe{
  \item{method}{A string indicating the ALR transform with the reference taxon.}
  \item{counts}{A matrix with one row per sample and \code{(n_taxa - 1)} columns.}
}
}
\description{
Applies the ALR transform to an integer matrix of counts using a specified
reference taxon. Samples are in rows and taxa in columns.
}
\details{
For each sample, the transform computes
\eqn{\mathrm{ALR}(x)_i = \log\!\big( (x_i + c)/(x_{ref} + c) \big)}, where
\eqn{c} is the pseudocount, for all taxa \eqn{i} except the reference.
}
\examples{
# Example with 2 samples and 2 taxa:
mat <- matrix(c(1, 2, 4, 8), nrow = 2, byrow = TRUE)
colnames(mat) <- c("TaxonA", "TaxonB")
# Using TaxonA as the reference.
out <- setaALR(mat, ref = "TaxonA", pseudocount = 0)
out$counts

}
