% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helperFuncs.R
\name{results}
\alias{results}
\title{results}
\usage{
results(DATA, type = c("NormalizedData", "ScaleFactors", "GenesFilteredOut"))
}
\arguments{
\item{DATA}{An object of class \code{SummarizedExperiment} that contains 
normalized single-cell expression and other metadata, and the output of the
\code{SCnorm} function.}

\item{type}{A character variable specifying which output is desired, 
with possible values "NormalizedData", "ScaleFactors", and "GenesFilteredOut". 
By default results() will
return type="NormalizedData", which is the matrix of normalized counts from SCnorm.
By specifiying type="ScaleFactors" a matrix of scale factors (only returned if 
reportSF=TRUE when running \code{SCnorm()}) can be obtained.
type="GenesFilteredOut" returns a list of genes that were not normalized using 
SCnorm, these are genes that
did not pass the filter critiera.}
}
\value{
A \code{data.frame} containing output as detailed in the
 description of the \code{type} input parameter
}
\description{
Convenient helper function to extract the results (
normalized data, list of genes filtered out, or scale factors). Results 
data.frames/matrices are stored in the 
\code{metadata} slot and can also be accessed without the help of this 
convenience function by calling \code{metadata(DataNorm)}.
}
\examples{
data(ExampleSimSCData)
Conditions = rep(c(1), each= 90)
#NormData <- SCnorm(Data=ExampleSimSCData, Conditions=Conditions)
#normDataMatrix <- results(NormData)
}
