% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotWithinFactor.R
\name{plotWithinFactor}
\alias{plotWithinFactor}
\title{Evaluate gene-specific factors in the the data.}
\usage{
plotWithinFactor(
  Data,
  withinSample = NULL,
  Conditions = NULL,
  FilterExpression = 0,
  NumExpressionGroups = 4
)
}
\arguments{
\item{Data}{can be a matrix of single-cell expression with cells
where rows are genes and columns are samples. Gene names should
not be a column in this matrix, but should be assigned to rownames(Data).
Data can also be an object of class \code{SummarizedExperiment} that contains 
the single-cell expression matrix and other metadata. The \code{assays} 
slot contains the expression matrix and is named \code{"Counts"}.  
This matrix should have one row for each gene and one sample for each column.  
The \code{colData} slot should contain a data.frame with one row per 
sample and columns that contain metadata for each sample.  This data.frame
should contain a variable that represents biological condition 
in the same order as the columns of \code{NormCounts}). 
Additional information about the experiment can be contained in the
\code{metadata} slot as a list.}

\item{withinSample}{a vector of gene-specific features.}

\item{Conditions}{vector of condition labels, this should correspond to 
 the columns of the un-normalized expression matrix. If provided the cells
will be colored by Condition instead of individually.}

\item{FilterExpression}{exclude genes having median of non-zero expression
below this threshold.}

\item{NumExpressionGroups}{the number of groups to split the within 
sample factor into, e.g genes will be split into equally sized groups
based on their GC content/Gene length/etc.}
}
\value{
produces a plot and returns the data the plot is based on.
}
\description{
This function can be used to evaluate the extent of 
  gene-specific biases in the data. If a bias exists, the plots provided 
  here will identify whether it affects cells equally or not. Correction 
  for such features may be considered especially if the bias is different 
  between conditions (see SCnorm vignette for details).
}
\examples{
 
data(ExampleSimSCData)
Conditions = rep(c(1,2), each= 90) 
exampleFactor = runif(dim(ExampleSimSCData)[1], 0, 1)
names(exampleFactor) = rownames(ExampleSimSCData)
#plotWithinFactor(Data = ExampleSimSCData,  
  #withinSample=exampleFactor, Conditions = Conditions)
}
\author{
Rhonda Bacher
}
