% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateEvalPlot.R
\name{generateEvalPlot}
\alias{generateEvalPlot}
\title{Internal plotting function.}
\usage{
generateEvalPlot(
  MedExpr,
  SeqDepth,
  Slopes,
  Name,
  NumExpressionGroups = 10,
  BeforeNorm = TRUE
)
}
\arguments{
\item{MedExpr}{non-zero median expression for all genes.}

\item{SeqDepth}{sequencing depth for each cell/sample.}

\item{Slopes}{per gene estimates of the count-depth relationship.}

\item{Name}{name for plot title.}

\item{NumExpressionGroups}{the number of groups to split the data into,
genes are split into equally sized groups based on their non-zero median
expression.}

\item{BeforeNorm}{whether dat have already been normalized.}
}
\value{
a plot of the un-normalized slope densities.
}
\description{
Genes are divided into NumExpressionGroups = 10 equally sized
   groups based on their non-zero median expression. Slope densities are plot
   for each group.
}
\author{
Rhonda Bacher
}
