% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SCnormFit.R
\name{SCnormFit}
\alias{SCnormFit}
\title{Fit group quantile regression for K groups}
\usage{
SCnormFit(Data, SeqDepth, Slopes, K, PropToUse = 0.25, Tau = 0.5, ditherCounts)
}
\arguments{
\item{Data}{can be a matrix of single-cell expression with cells
where rows are genes and columns are samples. Gene names should
not be a column in this matrix, but should be assigned to rownames(Data).
Data can also be an object of class \code{SummarizedExperiment} that contains 
the single-cell expression matrix and other metadata. The \code{assays} 
slot contains the expression matrix and is named \code{"Counts"}.  
This matrix should have one row for each gene and one sample for each column.  
The \code{colData} slot should contain a data.frame with one row per 
sample and columns that contain metadata for each sample.  This data.frame
should contain a variable that represents biological condition 
in the same order as the columns of \code{NormCounts}). 
Additional information about the experiment can be contained in the
\code{metadata} slot as a list.}

\item{SeqDepth}{sequencing depth for each cell/sample.}

\item{Slopes}{per gene estimates of the count-depth relationship.}

\item{K}{the number of groups for normalizing. If left unspecified, an
evaluation procedure will determine the optimal value of K
(recommended).}

\item{PropToUse}{proportion of genes closest to the slope mode used for
the group fitting, default is set at .25. This number #' mainly affects
speed.}

\item{Tau}{value of quantile for the quantile regression used to estimate
gene-specific slopes (default is median, Tau = .5 ).}

\item{ditherCounts}{whether to dither/jitter the counts, may be used for
data with many ties, default is FALSE.}
}
\value{
normalized expression matrix and matrix of scaling factors.
}
\description{
For each group K, a quantile regression is fit over all genes
   (PropToUse) for a grid of possible degree's d and quantile's tau. 
For each value of tau and d, the predicted expression values are obtained
   and regressed against the original sequencing depths.  The optimal tau
   and d combination is chosen as that closest to the mode of the gene
   slopes.
}
\author{
Rhonda Bacher
}
