% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perform_qc.R
\name{perform_qc}
\alias{perform_qc}
\title{Quality control for cells and bins}
\usage{
perform_qc(Y_raw, sampname_raw, ref_raw, QCmetric_raw,
        cov_thresh = 0, minCountQC = 20, 
        mapq20_thresh = 0.3, mapp_thresh = 0.9,
        gc_thresh = c(20, 80), nMAD = 3)
}
\arguments{
\item{Y_raw}{raw read count matrix returned
from \code{\link{get_coverage_scDNA}}}

\item{sampname_raw}{sample names for quality control returned
from \code{\link{get_bam_bed}}}

\item{ref_raw}{raw GRanges object with corresponding GC content
and mappability for quality control returned from
\code{\link{get_bam_bed}}}

\item{QCmetric_raw}{a QC metric for single cells returned from
\code{\link{get_samp_QC}}}

\item{cov_thresh}{scalar variable specifying the lower bound of read count
summation of each cell. Default is \code{0}}

\item{minCountQC}{the minimum read coverage required for
normalization and EM fitting. Defalut is \code{20}}

\item{mapq20_thresh}{scalar variable specifying the lower threshold
of proportion of reads with mapping quality greater than 20.
Default is \code{0.3}}

\item{mapp_thresh}{scalar variable specifying mappability of
each genomic bin. Default is \code{0.9}}

\item{gc_thresh}{vector specifying the lower and upper bound of
GC content threshold for quality control. Default is \code{20-80}}

\item{nMAD}{scalar variable specifying the number of MAD from the median
of total read counts adjusted by library size for each cell.
Default is \code{3}}
}
\value{
A list with components
    \item{Y}{read depth matrix after quality control}
    \item{sampname}{sample names after quality control}
    \item{ref}{A GRanges object specifying whole genomic
        bin positions after quality control}
    \item{QCmetric}{A data frame of QC metric for single cells
        after quality control}
}
\description{
Perform QC step on single cells and bins.
}
\examples{
Y_raw <- coverageObj.scopeDemo$Y
sampname_raw <- rownames(QCmetric.scopeDemo)
ref_raw <- ref.scopeDemo
QCmetric_raw <- QCmetric.scopeDemo
qcObj <- perform_qc(Y_raw = Y_raw, sampname_raw = sampname_raw,
                ref_raw = ref_raw, QCmetric_raw = QCmetric_raw)

}
\author{
Rujin Wang \email{rujin@email.unc.edu}
}
