% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_samp_QC.R
\name{get_samp_QC}
\alias{get_samp_QC}
\title{Get QC metrics for single cells}
\usage{
get_samp_QC(bambedObj)
}
\arguments{
\item{bambedObj}{object returned from \code{get_bam_bed}}
}
\value{
\item{QCmetric}{A matrix containing total number/proportion of reads,
    total number/proportion of mapped reads, total number/proportion
    of mapped non-duplicate reads, and number/proportion of reads with
    mapping quality greater than 20}
}
\description{
Perform QC step on single cells.
}
\examples{
library(WGSmapp)
library(BSgenome.Hsapiens.UCSC.hg38)
bamfolder <- system.file('extdata', package = 'WGSmapp')
bamFile <- list.files(bamfolder, pattern = '*.dedup.bam$')
bamdir <- file.path(bamfolder, bamFile)
sampname_raw <- sapply(strsplit(bamFile, '.', fixed = TRUE), '[', 1)
bambedObj <- get_bam_bed(bamdir = bamdir,
                            sampname = sampname_raw, 
                            hgref = "hg38")
QCmetric_raw = get_samp_QC(bambedObj)

}
\author{
Rujin Wang \email{rujin@email.unc.edu}
}
