% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_coverage_scDNA.R
\name{get_coverage_scDNA}
\alias{get_coverage_scDNA}
\title{Get read coverage from single-cell DNA sequencing}
\usage{
get_coverage_scDNA(bambedObj, mapqthres, seq, hgref = "hg19")
}
\arguments{
\item{bambedObj}{object returned from \code{get_bam_bed}}

\item{mapqthres}{mapping quality threshold of reads}

\item{seq}{the sequencing method to be used. This should be either
'paired-end' or 'single-end'}

\item{hgref}{reference genome. This should be 'hg19', 'hg38' or 'mm10'.
Default is human genome \code{hg19}.}
}
\value{
\item{Y}{Read depth matrix}
}
\description{
Get read coverage for each genomic bin across all single
    cells from scDNA-seq. Blacklist regions, such as segmental duplication 
    regions and gaps near telomeres/centromeres will be masked prior to
    getting coverage.
}
\examples{
library(WGSmapp)
library(BSgenome.Hsapiens.UCSC.hg38)
bamfolder <- system.file('extdata', package = 'WGSmapp')
bamFile <- list.files(bamfolder, pattern = '*.dedup.bam$')
bamdir <- file.path(bamfolder, bamFile)
sampname_raw <- sapply(strsplit(bamFile, '.', fixed = TRUE), '[', 1)
bambedObj <- get_bam_bed(bamdir = bamdir,
                            sampname = sampname_raw, 
                            hgref = "hg38")

# Getting raw read depth
coverageObj <- get_coverage_scDNA(bambedObj,
                                mapqthres = 40,
                                seq = 'paired-end', 
                                hgref = "hg38")
Y_raw <- coverageObj$Y

}
\author{
Rujin Wang \email{rujin@email.unc.edu}
}
