% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rqcReadWidthCalc.R, R/rqcReadWidthPlot.R
\name{rqcReadWidthCalc}
\alias{rqcReadWidthCalc}
\alias{rqcReadWidthPlot}
\title{Per read width plot}
\usage{
rqcReadWidthCalc(rqcResultSet)

rqcReadWidthPlot(rqcResultSet)
}
\arguments{
\item{rqcResultSet}{list of \code{RqcResultSet} objects created by
\code{\link{rqc}} and \code{\link{rqcQA}} functions.}
}
\value{
Plot object from \code{\link{ggplot}} function.
}
\description{
Creates bar graph of per read width from all elements of input list.
}
\section{Functions}{
\itemize{
\item \code{rqcReadWidthCalc}: calculates necessary statistics
}}

\examples{

checkpoint("Rqc", path=system.file(package="Rqc", "extdata"), {
  folder <- system.file(package="ShortRead", "extdata/E-MTAB-1147")
  files <- list.files(full.names=TRUE, path=folder)
  rqcResultSet <- rqcQA(files, pair=c(1,1), workers=1)
}, keep="rqcResultSet")
rqcReadWidthPlot(rqcResultSet)

}
\author{
Welliton Souza
}
\keyword{graphics}
\keyword{qc}
