% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{matdist}
\alias{matdist}
\title{Distance matrix of the similarity between the DNA sequences.}
\usage{
matdist(rrdnas)
}
\arguments{
\item{rrdnas}{Vector of codified DNA sequences (character vector).}
}
\value{
Matrix \eqn{n x n}, where \eqn{n} is the length of the largest 
original DNA sequence.
}
\description{
This function receives a vector of strings representing codified DNA 
sequences and returns a integer matrix representing the similarities 
between all sequences from input vectors.
}
\note{
This function is used internally to compute data for rqcFileHeatmap 
function.
}
\examples{
dna1 <- toRRDNA("atcgn")
dna2 <- toRRDNA("atcga")
matdist(c(dna1, dna2))
}
\seealso{
\code{\link{rqcFileHeatmap}}
}
\author{
Welliton Souza
}
