% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{fromRRDNA}
\alias{fromRRDNA}
\title{Revert codified DNA sequences to original DNA sequences.}
\usage{
fromRRDNA(rrdnas)
}
\arguments{
\item{rrdnas}{Vector of codified DNA (character vector).}
}
\value{
Vector of original DNA sequences (character vector).
}
\description{
This function receives a vector of strings containing codified DNA and 
returns a vector of string containing original DNA sequences.
}
\note{
This function is used internally to restore original DNA sequences 
stored in RqcResultSet objects (per file top reads).
}
\examples{
dna <- "ATCG"
dna.converted <- toRRDNA(dna)
dna.reverted <- fromRRDNA(dna.converted)
all.equal(dna, dna.reverted)
}
\seealso{
\code{\link{perFileTopReads}}
}
\author{
Welliton Souza
}
