% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeCluster.R
\docType{methods}
\name{run,RnBClusterRun-method}
\alias{run,RnBClusterRun-method}
\alias{run}
\title{run-methods}
\usage{
\S4method{run}{RnBClusterRun}(
  object,
  analysis.id,
  config.xml,
  split.differential = TRUE,
  dry.run = FALSE,
  long.cmd.thres = 1024L,
  queue = NULL
)
}
\arguments{
\item{object}{\code{\linkS4class{RnBClusterRun}} object}

\item{analysis.id}{analysis id. used for naming submitted jobs and log files}

\item{config.xml}{XML file specifying the analysis options and parameter settings}

\item{split.differential}{flag indicating whether to split the differnetial methylation module
into seperate jobs according to sample annotation column and region type.}

\item{dry.run}{Prevent the actual job submission. Rather only write to a shell script file}

\item{long.cmd.thres}{commands that are longer than this number will be encapsulated in shell scripts
rather than being submitted as direct command}

\item{queue}{The name of the queue the jobs are going to be submitted to}
}
\value{
Nothing of importance
}
\description{
Runs the analysis by submitting jobs for each module to the compute cluster
}
\examples{
\donttest{
#specify the xml file for your analysis
xml.file <- "MY_ANALYSIS_SETTINGS.XML"
#set the cluster architecture specific to your environment
arch <- new("ClusterArchitectureSGE")
rnb.cr <- new("RnBClusterRun",arch)
#set up the cluster so that 32GB of memory are required (SGE resource is called "mem_free")
rnb.cr <- setModuleResourceRequirements(rnb.cr,c(mem_free="32G"),"all")
#set up the cluster to use 4 cores on each node for all modules
rnb.cr <- setModuleNumCores(rnb.cr,4L,"all")
#set up the cluster to use 2 cores for the exploratory analysis module
rnb.cr <- setModuleNumCores(rnb.cr,2L,"exploratory")
#run the actual analysis (remove dry.run=TRUE, to really submit the jobs)
run(rnb.cr, "rnbeads_analysis", xml.file, dry.run=TRUE)
}
}
\author{
Fabian Mueller
}
