% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readGEO.R
\name{rnb.read.geo}
\alias{rnb.read.geo}
\title{Import methylation data from GEO}
\usage{
rnb.read.geo(
  accession = NULL,
  verbose = logger.isinitialized(),
  destdir = tempdir()
)
}
\arguments{
\item{accession}{Character string, starting with \code{"GSE"}, representing the GEO series for download and parsing.
Alternatively, this parameter can specify the file name of a previously downloaded GEO series
matrix file or its gzipped representation (in which case the filename must end in \code{".gz"}).
Other file formats, such as SOFT files, are not supported.}

\item{verbose}{Flag indicating if messages should be created informing about the progress. If the logger is
initialized prior to calling this function, the informative messages are sent to the logger.
Warnings and errors are not affected by this parameters, the function always outputs them.}

\item{destdir}{The destination directory for any downloads. Defaults to the (architecture-dependent) temporary
directory. Keep in mind that GEO series can be demanding in terms of storage space.}
}
\value{
\code{\linkS4class{RnBeadSet}} object with phenotypic and beta value information.
}
\description{
Imports Infinium 450K, MethylationEPIC or MethylationEPIC2 data series from the Gene Expression Omnibus. This function uses the
series matrix file.
}
\author{
Yassen Assenov, modified by Baris Kalem
}
