% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotations.R
\name{rnb.get.chromosomes}
\alias{rnb.get.chromosomes}
\title{rnb.get.chromosomes}
\usage{
rnb.get.chromosomes(assembly = "hg19")
}
\arguments{
\item{assembly}{Genome assembly of interest. See \code{\link{rnb.get.assemblies}} for the list of supported genomes.}
}
\value{
\code{character} vector of supported chromosomes for the specified genome assembly. The elements of the
        vector follow the \href{http://www.ensembl.org/}{Ensembl} convention (\code{"1"}, \code{"2"}, ...), and the
        names of this vector - the convention of the \href{http://genome.ucsc.edu/}{UCSC Genome Browser}
        (\code{"chr1"}, \code{"chr2"}, ...).
}
\description{
Gets the chromosome names supported for the specified assembly.
}
\examples{
\donttest{
"chrX" \%in\% names(rnb.get.chromosomes())
}
}
\author{
Pavlo Lutsik
}
