% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segmentation.R
\name{rnb.execute.segmentation}
\alias{rnb.execute.segmentation}
\title{rnb.execute.segmentation}
\usage{
rnb.execute.segmentation(
  rnb.set,
  sample.name,
  meth.level = 0.5,
  fdr = 5,
  min.cover = 5,
  n.cores = 1,
  chr.sel = "chr2",
  plot.path = getwd(),
  temp.dir = tempdir()
)
}
\arguments{
\item{rnb.set}{An object of type \code{\link{RnBiseqSet-class}} containing methylation and coverage information.}

\item{sample.name}{The sample for which segmentation is to be executed. Segemntation can only be exectued for each sample
individually.}

\item{meth.level}{Methylation cutoff to be used in UMR/LMR computation}

\item{fdr}{False discovery rate cutoff to be used in percent}

\item{min.cover}{The coverage threshold}

\item{n.cores}{The number of cores available for analysis}

\item{chr.sel}{Selected chromosome for model training in "chrAB" format. Defaults to "chr2".}

\item{plot.path}{Location on disk on which diagnostic plots are to be stored. Defaults to the working directory.}

\item{temp.dir}{The temporary directory. Defaults to the R temporary directory.}
}
\value{
The input RnBSet object with segementation added as an additional region type. Furthermore, three new annotations
         are set globally containing segmentation into PMDs, UMRs/LMRs, and HMDs for the sample that was specified.
}
\description{
This function computes methylation segmentation by MethylSeekR into PMDs, UMRs/LMRs, and HMDs. It is recommened to only
execute this function on WGBS data  (with coverage >=10 according to the developer's recommendation), but could also be
used with RRBS_HaeIII without guarantee and the results should be interpreted carefully.
}
\details{
For further descriptions on the methods, see \code{MethylSeekR}-documentation. The new annotations can be accessed
         via \code{rnb.get.annotation("[PMDs,UMRs,LMRs,HMDs]_[sample.name]")}.
}
\references{
1. Burger, Lukas, Gaidatzis, Dimos, Schuebeler, Dirk, and Stadler, Michael B. (2013)
            Identification of active regulatory regions from DNA methylation data.
            Nucleic Acids Research 41(16):e155.
}
\author{
Michael Scherer, based on a script by Abdulrahman Salhab
}
