% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plottingUtils.R
\name{rnb.color.legends}
\alias{rnb.color.legends}
\title{rnb.color.legends}
\usage{
rnb.color.legends(
  report,
  legends,
  fprefix = ifelse(is.character(legends), "legend", "legend_"),
  description = "Color legend.",
  setting.names = NULL,
  size.factor = 3
)
}
\arguments{
\item{report}{Report to contain the legend figure. This must be an object of type \code{\linkS4class{Report}}.}

\item{legends}{Color legend in the form of a non-empty \code{character} vector. Element names denote legend
labels, and the elements themselves specify colors. This parameter can also be a \code{list} of
color legends. Special restrictions apply to the names of the list elements, see \emph{Details}.}

\item{fprefix}{File name or prefix for the plot files.}

\item{description}{Text of the figure description. See the correponding parameter in
\code{\link{rnb.add.figure}} for more details.}

\item{setting.names}{One-element list containing a plot file descriptor, when \code{legends} is a list. See the
corresponding parameter in \code{\link{rnb.add.figure}} for more details. If this is set to
\code{NULL} (default), the list is automatically created using \code{names(legends)} (when
\code{legends} is a list), or as an empty list (when \code{legends} is a vector).}

\item{size.factor}{Relative size, in inches of the plots. Legends are displayed in columns of up to 10 items; each
column is effectively a square with the specified size.}
}
\value{
The modified report.
}
\description{
Creates a figure in the given report that contains one or more color legends.
}
\details{
In case \code{legends} specifies multiple legends in the form of a list, \code{names(legends)} are appended
         to \code{fprefix} to generate file names. In order to ensure independence of the operating system, there are
         strong restrictions on these names. They can consist of the following symbols only: Latin letters, digits,
         dot (\code{.}), dash (\code{-}) and underline (\code{_}).
}
\author{
Yassen Assenov
}
