% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataExport.R
\name{rnb.RnBSet.to.GRangesList}
\alias{rnb.RnBSet.to.GRangesList}
\title{rnb.RnBSet.to.GRangesList}
\usage{
rnb.RnBSet.to.GRangesList(
  rnb.set,
  reg.type = "sites",
  return.regular.list = FALSE
)
}
\arguments{
\item{rnb.set}{Object of class \code{\linkS4class{RnBSet}}}

\item{reg.type}{region type to be converted}

\item{return.regular.list}{flag indicating whether a regular \code{list} object should be returned instead
of a \code{GRangesList}. Might improve performance in some cases}
}
\value{
a \code{GRangesList} or \code{list} object with one list element (\code{GRanges}) for each sample in \code{rnb.set}
}
\description{
convert an \code{\linkS4class{RnBSet}} object to a \code{GRangesList} object
}
\examples{
\donttest{
library(RnBeads.hg19)
data(small.example.object)
logger.start(fname=NA)
result <- rnb.RnBSet.to.GRangesList(rnb.set.example)
}
}
\author{
Fabian Mueller
}
