% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RnBSet-class.R
\docType{methods}
\name{meth,RnBSet-method}
\alias{meth,RnBSet-method}
\alias{meth}
\title{meth-methods}
\usage{
\S4method{meth}{RnBSet}(object, type = "sites", row.names = FALSE, i = NULL, j = NULL)
}
\arguments{
\item{object}{dataset of interest.}

\item{type}{\code{character} singleton. If this is set to \code{"sites"} (default), DNA methylation information
for each available site is returned. Otherwise, this should be one of region types for for which
summarized DNA methylation information is computed in the given dataset.}

\item{row.names}{flag indicating if row names are to be generated in the result.}

\item{i}{indices of sites/regions to be retrieved. By default (\code{NULL}), all will be retrieved.}

\item{j}{indices of samples to be retrieved. By default (\code{NULL}), all will be retrieved.}
}
\value{
\code{matrix} with methylation beta values.
}
\description{
Extracts DNA methylation information (beta values) for a specified set of genomic features.
}
\examples{
\donttest{
library(RnBeads.hg19)
data(small.example.object)
## per-site beta-value matrix
mm<-meth(rnb.set.example, row.names=TRUE)
head(mm)
## beta-values for each covered gene
gmm<-meth(rnb.set.example, type="gene", row.names=TRUE)
head(gmm)
}
}
\seealso{
\code{\link[=mval,RnBSet-method]{mval}} for calculating M values
}
