% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RnBSet-class.R
\docType{methods}
\name{covg,RnBSet-method}
\alias{covg,RnBSet-method}
\alias{covg}
\title{covg-methods}
\usage{
\S4method{covg}{RnBSet}(object, type = "sites", row.names = FALSE, i = NULL, j = NULL)
}
\arguments{
\item{object}{Dataset of interest.}

\item{type}{\code{character} singleton. If \code{sites} DNA methylation information per each available
site is returned. Otherwise should be one of region types for for which the summarized
coverage information is available}

\item{row.names}{Flag indicating of row names are to be generated in the result.}

\item{i}{indices of sites/regions to be retrieved. By default (\code{NULL}), all will be retrieved.}

\item{j}{indices of samples to be retrieved. By default (\code{NULL}), all will be retrieved.}
}
\value{
coverage information available for the dataset in the form of a \code{matrix}.
}
\description{
Extract coverage information from an object of \code{RnBSet} class.
}
\examples{
\donttest{
library(RnBeads.hg19)
data(small.example.object)
## per-site beta-value matrix
cvg<-covg(rnb.set.example, row.names=TRUE)
head(cvg)
}
}
