% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differentialMethylation.R
\name{combineTestPvalsMeth}
\alias{combineTestPvalsMeth}
\title{combineTestPvalsMeth}
\usage{
combineTestPvalsMeth(
  pvalues,
  testWeights = NULL,
  correlated = FALSE,
  methExpectedTestCorrelation = 0.8
)
}
\arguments{
\item{pvalues}{p-values to combine}

\item{testWeights}{weights for the individual tests}

\item{correlated}{are the individual tests correlated}

\item{methExpectedTestCorrelation}{expected correlation. Empirically approximated to the default value of 0.8 for DNA-methylation}
}
\value{
the combined p-value
}
\description{
combine p-values of multiple tests using (a generalization of) Fisher's method. The parameter setting here is taylored to DNA methylation, but can be adapted. 
Reference: Makambi, K. (2003). Weighted inverse chi-square method for correlated significance tests. Journal of Applied Statistics, 30(2), 225-234.
}
\examples{
\donttest{
p.vals <- 10^-c(0,1,5)
combineTestPvalsMeth(p.vals)
}
}
\author{
Fabian Mueller, Christoph Bock
}
