% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modules.R
\name{identifyModules}
\alias{identifyModules}
\title{Apply dimensionality reduction using Weighted Gene Correlation Network Analysis}
\usage{
identifyModules(
  X,
  power,
  center_X = TRUE,
  scale_X = TRUE,
  assay_name = "normal",
  ...
)
}
\arguments{
\item{X}{Either a \link[SummarizedExperiment]{SummarizedExperiment} object
or a matrix containing data to be subject to WGCNA. \code{X} should have rows as
features and columns as samples.}

\item{power}{An integer representing the soft-thresholding power to be
used to define modules. See the
\link[ReducedExperiment]{assessSoftThreshold} function for aid in
determining this parameter.}

\item{center_X}{If \code{TRUE}, \code{X} is centered (i.e., features / rows are transformed
to have a mean of 0) prior to WGCNA.}

\item{scale_X}{If \code{TRUE}, \code{X} is scaled (i.e., features / rows are transformed
to have a standard deviation of 1) before WGCNA.}

\item{assay_name}{If \code{X} is a
\link[SummarizedExperiment]{SummarizedExperiment}, then this should be the
name of the assay to be subject to WGCNA.}

\item{...}{Additional arguments to be passed to
\link[ReducedExperiment]{runWGCNA}.}
}
\value{
A \link[ReducedExperiment]{ModularExperiment} is returned
containing the input data (i.e., the original data matrix in addition to
other slots if a \link[SummarizedExperiment]{SummarizedExperiment} was used
as input). Additionally contains the results of module analysis, stored in
the \code{reduced} and \code{assignments} slots. The \code{center_X}, \code{scale_X},
\code{loadings}, \code{threshold} and \code{dendrogram} slots may also be filled depending
on the arguments given to \code{identifyModules}.
}
\description{
Performs Weighted gene correlation network analysis (WGCNA) and packages
both the input data and subsequent results into a
\link[ReducedExperiment]{ModularExperiment}. Calls
\link[ReducedExperiment]{runWGCNA} to perform the analysis; see its
documentation page for more information on the ICA method, parameters
and outputs.
}
\examples{
# Get the airway data as a SummarizedExperiment (with a subset of features)
set.seed(2)
airway_se <- ReducedExperiment:::.getAirwayData(n_features = 500)

# Select soft-thresholding power to use (use capture.output to hide WGCNA's prints)
WGCNA::disableWGCNAThreads()
invisible(capture.output(fit_indices <- assessSoftThreshold(airway_se)))
estimated_power <- fit_indices$Power[fit_indices$estimated_power]

# Identify modules using WGCNA
airway_me <- identifyModules(airway_se, verbose = 0, power = estimated_power)
airway_me

}
\seealso{
\code{\link[=runWGCNA]{runWGCNA()}},
\code{\link[WGCNA:blockwiseModules]{WGCNA::blockwiseModules()}},
\code{\link[WGCNA:pickSoftThreshold]{WGCNA::pickSoftThreshold()}}
}
\author{
Jack Gisby
}
