% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/methods-FactorisedExperiment.R
\docType{class}
\name{FactorisedExperiment-class}
\alias{FactorisedExperiment-class}
\alias{.FactorisedExperiment}
\alias{FactorisedExperiment}
\title{FactorisedExperiment: A container for the results of factor analysis}
\usage{
FactorisedExperiment(
  reduced = new("matrix"),
  scale = TRUE,
  center = TRUE,
  loadings = new("matrix"),
  stability = NULL,
  ...
)
}
\arguments{
\item{reduced}{A \code{matrix}, produced by factor analysis, with rows
representing samples and columns representing factors.}

\item{scale}{Either a boolean, representing whether or not the original data
has been scaled to unit variance, or a numeric vector indicating the
standard deviations of the original features (as produced by
\link[base]{scale}.)}

\item{center}{Either a boolean, representing whether or not the original data
has been centered to have a mean of 0, or a numeric vector indicating the
means of the original features (as produced by
\link[base]{scale}.)}

\item{loadings}{A \code{matrix}, produced by factor analysis, with rows
representing features and columns representing factors.}

\item{stability}{A vector containing some measure of stability or variance
explained for each factor. If factor analysis was performed using
\link[ReducedExperiment]{estimateFactors} and \code{use_stability = TRUE}, this
slot will indicate the stability of the factors across multiple runs of ICA.}

\item{...}{Additional arguments to be passed to
\link[ReducedExperiment]{ReducedExperiment}.}
}
\value{
Constructor method returns a
\link[ReducedExperiment]{FactorisedExperiment} object.
}
\description{
A container inheriting from the \link[ReducedExperiment]{ReducedExperiment}
class, that
contains one or more data matrices, to which factor analysis has been applied
to identify a reduced set of features. A
\link[ReducedExperiment]{FactorisedExperiment} can be created directly in
a similar manner to a \link[SummarizedExperiment]{SummarizedExperiment}.
Alternatively, the \link[ReducedExperiment]{estimateFactors} function
can be used to both apply factor analysis and generate a
\link[ReducedExperiment]{FactorisedExperiment} from the results.
}
\examples{
# Create randomised data with the following dimensions
i <- 300 # Number of features
j <- 100 # Number of samples
k <- 10 # Number of factors

# In this case we use random assay, reduced and loadings data, but in
# practice these will likely be the result of applying some kind of factor
# analysis to the assay data (e.g., gene expression data) from some study.
rand_assay_data <- ReducedExperiment:::.makeRandomData(i, j, "gene", "sample")
rand_reduced_data <- ReducedExperiment:::.makeRandomData(j, k, "sample", "factor")
rand_loadings <- ReducedExperiment:::.makeRandomData(i, k, "gene", "factor")

fe <- FactorisedExperiment(
    assays = list("normal" = rand_assay_data),
    reduced = rand_reduced_data,
    loadings = rand_loadings
)

fe

}
\seealso{
\code{\link[=ReducedExperiment]{ReducedExperiment()}},
\code{\link[=ModularExperiment]{ModularExperiment()}},
\code{\link[=estimateFactors]{estimateFactors()}}
}
\author{
Jack Gisby
}
