% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportedWrappers.R
\name{startRedeR}
\alias{startRedeR}
\title{Start RedeR app from R}
\usage{
startRedeR(...)
}
\arguments{
\item{...}{Arguments passed to the \code{\link{RedPort}} function.}
}
\value{
System call to start the RedeR application.
}
\description{
Method to launch RedeR application from R.
}
\details{
The \code{startRedeR()} is a wrapper function that launches the RedeR app
by calling \code{RedPort()} and \code{calld()} methods. Therefore, these
methods no longer needed to be called by the user from RedeR version >=3.
\itemize{
List of functions that uses \code{startRedeR()}:
\item{\link{addGraphToRedeR}}{ Methods to display igraph objects.}
\item{\link{getGraphFromRedeR}}{ Methods to wrap up RedeR graphs.}
\item{\link{addLegendToRedeR}}{ Methods to display legends.}
\item{\link{relaxRedeR}}{ Start RedeR's interactive layout.}
\item{\link{resetRedeR}}{ Reset an active RedeR session.}
\item{\link{exitRedeR}}{ Close an active RedeR session.}
\item{\link{pingRedeR}}{ Test the R-to-Java interface.}
\item{\link{addNodes}}{ Add nodes to an active RedeR application.}
\item{\link{addEdges}}{ Add edges to an active RedeR application.}
\item{\link{selectNodes}}{ Select nodes in an active RedeR application.}
\item{\link{selectEdges}}{ Select edges in an active RedeR application.}
\item{\link{deleteNodes}}{ Delete nodes from an active RedeR application.}
\item{\link{deleteEdges}}{ Delete edges from an active RedeR application.}
\item{\link{nestNodes}}{ Nest nodes into containers.}
\item{\link{mergeOutEdges}}{ Assign 'out-edges' to containers.}
}
}
\examples{
# Load RedeR
library(RedeR)

\donttest{
# Start the RedeR interface
startRedeR()
}

}
\seealso{
\code{\link{addGraphToRedeR}}
}
\author{
Sysbiolab.
}
