% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportedOtherMethods.R
\docType{methods}
\name{deleteNodes,character-method}
\alias{deleteNodes,character-method}
\alias{deleteNodes}
\title{deleteNodes}
\usage{
\S4method{deleteNodes}{character}(nodes, ...)
}
\arguments{
\item{nodes}{A vector with node names.}

\item{...}{Arguments passed to internal checks (ignore).}
}
\value{
Remove graph objects from RedeR app.
}
\description{
Delete nodes from an active RedeR application.
}
\examples{
# Load RedeR and igraph
library(RedeR)
library(igraph)

# Create a vector with node names
nodes <- c("n1", "n2", "n3", "n4", "n5")

\donttest{
# Start the RedeR interface
startRedeR()

# Add and delete nodes
addNodes(nodes)
deleteNodes(c("n1", "n3"))
}

}
\seealso{
\code{\link{addGraphToRedeR}}, \code{\link{getGraphFromRedeR}}.
}
\author{
Sysbiolab.
}
