% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis_request.R
\name{set_method}
\alias{set_method}
\title{set_method}
\usage{
set_method(request, method, ...)
}
\arguments{
\item{request}{The \code{\link{ReactomeAnalysisRequest}} to adjust}

\item{method}{The name of the method to use. Use \code{\link{get_reactome_methods}} to
retrieve all available methods}

\item{...}{Additional parameters passed to specific implementations}
}
\value{
The \code{\link{ReactomeAnalysisRequest}} with the adapted method
}
\description{
Set the analysis method used by the \code{\link{ReactomeAnalysisRequest}}
}
\examples{
# create a request using Camera as an analysis
data(griss_melanoma_proteomics)
library(methods)

my_request <- ReactomeAnalysisRequest(method = "Camera")

print(my_request)

# change the method to ssGSEA
my_request <- set_method(my_request, "ssGSEA")

print(my_request)
}
