% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis_result.R
\name{reactome_links}
\alias{reactome_links}
\title{reactome_links}
\usage{
reactome_links(x, ...)
}
\arguments{
\item{x}{ReactomeAnalysisResult.}

\item{...}{Additional parameters for specific implementations.}
}
\value{
If \code{return_result} is set to \code{TRUE}, a vector of the available visualizations.
}
\description{
Displays detailed information about the result visualizations in Reactome.
}
\examples{
# Note: This function only works with a newly created result
# since the visualization links only stay active for 7 days

# load an example result
library(ReactomeGSA.data)
data(griss_melanoma_result)

# get the reactome link - this does only work
# with new results
reactome_links(griss_melanoma_result)
}
\seealso{
Other ReactomeAnalysisResult functions: 
\code{\link{get_result}()},
\code{\link{names,ReactomeAnalysisResult-method}},
\code{\link{open_reactome}()},
\code{\link{pathways}()},
\code{\link{plot_correlations}()},
\code{\link{plot_gsva_heatmap}()},
\code{\link{plot_gsva_pathway}()},
\code{\link{plot_heatmap}()},
\code{\link{plot_volcano}()},
\code{\link{result_types}()}
}
\concept{ReactomeAnalysisResult functions}
