% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_functions.R
\name{plot_volcano}
\alias{plot_volcano}
\title{plot_volcano}
\usage{
plot_volcano(x, ...)
}
\arguments{
\item{x}{ReactomeAnalysisResult. The analysis result to plot the volcano plot for.}

\item{...}{Additional parameters for specific implementations.}
}
\value{
A ggplot2 plot object representing the volcano plot.
}
\description{
Creates a volcano plot for the pathway analysis result. Every point represents one
pathway, the x-axis the log fold-change and the y-axis the adjusted p-value (-log10).
}
\details{
This function is only available for GSA-based analysis results.
}
\examples{
# load an example result
library(ReactomeGSA.data)
data(griss_melanoma_result)

# create the volcano plot for the first dataset
plot_obj <- plot_volcano(griss_melanoma_result)

# display the plot using `print(plot_obj)`
}
\seealso{
Other ReactomeAnalysisResult functions: 
\code{\link{get_result}()},
\code{\link{names,ReactomeAnalysisResult-method}},
\code{\link{open_reactome}()},
\code{\link{pathways}()},
\code{\link{plot_correlations}()},
\code{\link{plot_gsva_heatmap}()},
\code{\link{plot_gsva_pathway}()},
\code{\link{plot_heatmap}()},
\code{\link{reactome_links}()},
\code{\link{result_types}()}
}
\concept{ReactomeAnalysisResult functions}
