% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bwa_mem.R
\name{bwa_mem}
\alias{bwa_mem}
\title{R wrapper to run BWA alignment tool BWA-MEM}
\usage{
bwa_mem(type = c("single", "paired"), index_prefix, fastq_files, sam_file, ...)
}
\arguments{
\item{type}{String specifying type of reads:
"single" for single-end reads (default) or
"paired" for paired-end reads.}

\item{index_prefix}{String specifying prefix of the BWA index.}

\item{fastq_files}{Character vector specifying paths of fastq files.
If \code{type=="single"}, must be of length 1.
If \code{type=="paired"}, must be of length 2.}

\item{sam_file}{String specifying filename of the SAM
aligmment output.}

\item{...}{Other arguments to pass to the \code{bwa aln} alignment.}
}
\value{
No return value. Output SAM file is
    produced as side effect.
}
\description{
R wrapper to run BWA alignment tool BWA-MEM.
}
\examples{
dir <- tempdir()
fasta <- system.file(package="Rbwa",
                     "fasta/chr12.fa")
fastq <- system.file(package="Rbwa",
                     "fastq/sequences.fastq")
index_prefix <- file.path(dir,"chr12")
bwa_build_index(fasta, index_prefix=index_prefix)

bwa_mem(index_prefix=index_prefix,
        fastq_files=fastq,
        sam_file=file.path(dir, "output.sam"))

}
\author{
Jean-Philippe Fortin
}
