% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_data.R
\name{read_zarr_array}
\alias{read_zarr_array}
\title{Read a Zarr array}
\usage{
read_zarr_array(zarr_array_path, index, s3_client)
}
\arguments{
\item{zarr_array_path}{Path to a Zarr array. A character vector of length 1.
This can either be a location on a local file system or the URI to an array
in S3 storage.}

\item{index}{A list of the same length as the number of dimensions in the
Zarr array.  Each entry in the list provides the indices in that dimension
that should be read from the array.  Setting a list entry to \code{NULL} will
read everything in the associated dimension.  If this argument is missing
the entirety of the the Zarr array will be read.}

\item{s3_client}{Object created by \code{\link[paws.storage:s3]{paws.storage::s3()}}. Only required for a
file on S3. Leave as \code{NULL} for a file on local storage.}
}
\value{
An array with the same number of dimensions as the input array. The
extent of each dimension will correspond to the length of the values
provided to the \code{index} argument.
}
\description{
Read a Zarr array
}
\examples{

## Using a local file provided with the package
## This array has 3 dimensions
z1 <- system.file("extdata", "zarr_examples", "row-first", "int32.zarr", package = "Rarr")

## read the entire array
read_zarr_array(zarr_array_path = z1)

## extract values for first 10 rows, all columns, first slice
read_zarr_array(zarr_array_path = z1, index = list(1:10, NULL, 1))

\donttest{
## using a Zarr file hosted on Amazon S3
## This array has a single dimension with length 2729077
z2 <- "https://noaa-nwm-retro-v2-zarr-pds.s3.amazonaws.com/feature_id/"

## read the entire array
read_zarr_array(zarr_array_path = z2)

## read alternating elements
read_zarr_array(zarr_array_path = z2, index = list(seq(1, 576, 2)))
}

}
