% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_data.R
\name{write_zarr_array}
\alias{write_zarr_array}
\title{Write an R array to Zarr}
\usage{
write_zarr_array(
  x,
  zarr_array_path,
  chunk_dim,
  data_type = storage.mode(x),
  order = "F",
  compressor = use_zlib(),
  fill_value,
  nchar,
  dimension_separator = "."
)
}
\arguments{
\item{x}{The R array (or object that can be coerced to an array) that will be
written to the Zarr array.}

\item{zarr_array_path}{Character vector of length 1 giving the path to the
new Zarr array.}

\item{chunk_dim}{Dimensions of the array chunks. Should be a numeric vector
with the same length as the \code{dim} argument.}

\item{data_type}{Character vector giving the data type of the new array.
Valid options are: "integer", "double", "character", "logical", which are
based on standard R data types. You can also use the analogous Numpy
formats: "|i1", "<i2", "<i4", "<f4", "<f8", "|S", "|b1".
If this argument isn't provided the \code{fill_value} will be used to determine
the datatype.}

\item{order}{Define the layout of the bytes within each chunk.  Valid options
are 'column', 'row', 'F' & 'C'.  'column' or 'F' will specify
"column-major" ordering, which is how R arrays are arranged in memory.
'row' or 'C' will specify "row-major" order.}

\item{compressor}{What (if any) compression tool should be applied to the
array chunks.  The default is to use \code{zlib} compression. Supplying \code{NULL}
will disable chunk compression. See \link{compressors} for more details.}

\item{fill_value}{The default value for uninitialized portions of the array.
Does not have to be provided, in which case the default for the specified
data type will be used.}

\item{nchar}{For character arrays this parameter gives the maximum length of
the stored strings. If this argument is not specified the array provided to
\code{x} will be checked and the length of the longest string found will be used
so no data are truncated. However this may be slow and providing a value to
\code{nchar} can provide a modest performance improvement.}

\item{dimension_separator}{The character used to to separate the dimensions
in the names of the chunk files.  Valid options are limited to "." and "/".}
}
\value{
The function is primarily called for the side effect of writing to
disk. Returns (invisibly) \code{TRUE} if the array is successfully written.
}
\description{
Write an R array to Zarr
}
\examples{

new_zarr_array <- file.path(tempdir(), "integer.zarr")
x <- array(1:50, dim = c(10, 5))
write_zarr_array(
  x = x, zarr_array_path = new_zarr_array,
  chunk_dim = c(2, 5)
)

}
