% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downloadRSet.R
\name{downloadRSet}
\alias{downloadRSet}
\title{Download a RadioSet object}
\usage{
downloadRSet(
  name,
  saveDir = tempdir(),
  rSetFileName = NULL,
  verbose = TRUE,
  timeout = 600
)
}
\arguments{
\item{name}{\code{Character} string, the name of the PhamracoSet to download.}

\item{saveDir}{\code{Character} string with the folder path where the
RadioSet should be saved. Defaults to \code{'./rSets/'}. Will create
directory if it does not exist.}

\item{rSetFileName}{\code{character} string, the file name to save the dataset under}

\item{verbose}{\code{bool} Should status messages be printed during download.
Defaults to TRUE.}

\item{timeout}{`numeric(1)` How long to wait before erroring due to timeout,
in seconds. Default it 600s (10 minutes).}
}
\value{
A rSet object with the dataset, downloaded from our server
}
\description{
This function allows you to download a \code{RadioSet} object for use with this
package. The \code{RadioSets} have been extensively curated and organized within
a PharacoSet class, enabling use with all the analysis tools provided in
\code{PharmacoGx}.
}
\examples{
if (interactive()) {
cleveland <- downloadRSet("Cleveland")
}

}
