% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prioritising.r
\name{prioritise}
\alias{prioritise}
\title{Prioritising candidate genes.}
\usage{
prioritise(X, ref_index, cand_index, anno, Factor, Weights, threshold)
}
\arguments{
\item{X}{A matrix of gene expression values.}

\item{ref_index}{A vector of indices of reference genes.}

\item{cand_index}{A vector of indices of candidate genes.}

\item{anno}{A dataframe or a matrix containing the annotation of arrays in \code{X}.}

\item{Factor}{A character string corresponding to a column name of \code{anno}; this
should be the same used to generate \code{Weights}.}

\item{Weights}{An object of class \code{Weights} or a list of weights. If \code{NULL}
the unweighted correlation is used.}

\item{threshold}{A value in the range \eqn{[0,1]}.}
}
\value{
\code{prioritise} returns a matrix with three columns. The first column gives 
the names of the genes that were prioiritised, while the second column gives the 
number of correlations above the threshold for the gene in question. The
columns gives the sum of the absolute value of all correlations with reference genes
above the threshold.
}
\description{
\code{prioritise} returns a set of genes from a candidate set of genes that are
correlated above a provided threshold with at least one of the provided reference
genes.
}
\examples{
Y<-simulateGEdata(500, 500, 10, 2, 5, g=NULL, Sigma.eps=0.1, 
250, 100, intercept=FALSE, check.input=TRUE)
colnames(Y$Y)<-1:dim(Y$Y)[2]
anno<-as.matrix(sample(1:5, dim(Y$Y)[1], replace=TRUE))
colnames(anno)<-"Factor"
weights<-findWeights(Y$Y, anno, "Factor")
prioritise(Y$Y, 1:10, 51:150, anno, "Factor", weights, 0.6)
}
\author{
Saskia Freytag
}
