% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllPlotsMBR.R
\name{mbrPlotInteraction}
\alias{mbrPlotInteraction}
\title{Plot interaction effects between two continuous variables.}
\usage{
mbrPlotInteraction(
  model,
  vars,
  xlim = NULL,
  ylim = NULL,
  zlim = NULL,
  xlab = NULL,
  ylab = NULL,
  zlab = NULL,
  zcenter = NULL,
  zlog = NULL,
  zcols = c("#008080ff", "#d45500ff"),
  ycols = c("#4A97C9", "#D92522"),
  showdata = FALSE,
  datacols = "grey50",
  fname = "interplot",
  fpath = ".",
  width = 4.5,
  height = 4,
  plotype = c("3D", "2D"),
  plotpdf = FALSE
)
}
\arguments{
\item{model}{An object of class 'lm', 'glm', or 'coxph'.}

\item{vars}{A character vector of length 2 with the names of two varibles in the 'model'.}

\item{xlim}{A numeric vector of length 2, i.e. xlim = c(x1, x2), 
indicating the x limits of the plot. If xlim = NULL, it will be derevided  
from the observed data ranges.}

\item{ylim}{A numeric vector of length 2, i.e. ylim = c(y1, y2), 
indicating the y limits of the plot. If ylim = NULL, it will be derevided 
from the observed data ranges.}

\item{zlim}{A numeric vector of length 2, i.e. zlim = c(z1, z2), 
indicating the z limits of the plot. If zlim = NULL, it will be derevided 
from the observed data ranges.}

\item{xlab}{A string with the label for the x-axis.}

\item{ylab}{A string with the label for the y-axis.}

\item{zlab}{A string with the label for the z-axis.}

\item{zcenter}{A numeric value indicating a z value to center the color scale.}

\item{zlog}{A logical value indicating whether the z axis is to be logarithmic.}

\item{zcols}{A vector of length 2 indicating a diverging color scheme 
for the z-axis varible.}

\item{ycols}{A vector of length 2 indicating a diverging color scheme 
for the y-axis varible (only used when type='2D').}

\item{showdata}{A logical value indicating whether to show the original data 
used to fit linear model.}

\item{datacols}{When 'showdata = TRUE', this can be a named vector of colors for 
data points (names should match samples in the 'model' object). Alternativelly, 
it can be a single color value.}

\item{fname}{A string. The name of the PDF file which will contain the plot.}

\item{fpath}{A string. The directory where the file will be saved.}

\item{width}{A numeric value. The width of the plot.}

\item{height}{A numeric value. The height of the plot.}

\item{plotype}{A string indicating '2D' of '3D' plot type. If plotype = '2D', 
the z-axis (and all related parameters) is transposed to the y-axis.}

\item{plotpdf}{A logical value.}
}
\value{
A interaction plot.
}
\description{
This function plots the interaction effects between two continuous variables 
for linear, logistic, or Cox models.
}
\examples{
#-- Example of simulated data, with response variable modelled by:
#-- (1) Main effects of 'reg1' and 'reg2'
#-- (2) Interaction effects between 'reg1' and 'reg2' 
#-- (3) Additional random uniform noise
reg1 <- rnorm(1000,0,2)
reg2 <- rnorm(1000,0,2)
response <- 3*reg1 + 2*reg1*reg2 + runif(1000,0,2)
dataset <- data.frame(reg1, reg2, response)
model <- lm(response ~ reg1*reg2, data=dataset)
mbrPlotInteraction(model, vars=c("reg1","reg2"))

}
