\name{RTNduals-package}
\alias{RTNduals-package}
\alias{RTNduals}
\docType{package}

\title{
RTNduals: An R/Bioconductor package for analysis of co-regulation and inference of 'dual regulons'.
}

\description{
RTNduals is a tool that searches for possible co-regulatory loops between regulon pairs generated by the RTN package. It compares the shared targets in order to infer 'dual regulons', a new concept that tests whether regulators can co-operate or compete in influencing targets.
}

\details{
\tabular{ll}{
Package: \tab RTNduals\cr
Type: \tab Package\cr
Depends: \tab R (>= 3.5.0), methods, RTN\cr 
Imports: \tab grDevices, stats, utils\cr
Suggests: \tab knitr, rmarkdown, BiocStyle, RUnit, BiocGenerics\cr 
License: \tab Artistic-2.0\cr
biocViews: \tab NetworkInference, NetworkEnrichment, GeneRegulation, GeneExpression, GraphAndNetwork\cr
}
}

\section{Index}{

\tabular{ll}{
\link{MBR-class}: \tab an S4 class for co-regulation analysis and inference of 'dual regulons'.\cr
\link{mbrAssociation}: \tab motifs analysis and inference of "dual regulons".\cr
\link{mbrPriorEvidenceTable}: \tab adds external evidences to "dual regulons".\cr
\link{mbrPlotDuals}: \tab plot shared targets between regulons.\cr
\link{mbrPlotInteraction}: \tab plots interaction effects between continuous variables.\cr
\link{tni2mbrPreprocess}: \tab a preprocessing function for objects of class MBR.\cr
\link{mbrGet}: \tab get information from individual slots in MBR object.\cr
}

Further information is available in the vignettes by typing 
\code{vignette("RTNduals")}. Documented topics are also available in HTML by typing \code{help.start()} and 
selecting the RTNduals package from the menu.
}

\author{
Vinicius S. Chagas, Clarice S. Groeneveld, Kerstin B Meyer, Gordon Robertson, Mauro A. A. Castro
}

\references{
Fletcher M.N.C. et al., \emph{Master regulators of FGFR2 signalling and breast cancer risk.} Nature Communications, 4:2464, 2013.

Castro M.A.A. et al., \emph{Regulators of genetic risk of breast cancer identified by integrative network analysis.} Nature Genetics, 48:12-21, 2016.
}

\keyword{ package }

