% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getBroadSubtypes.R
\name{getBroadSubtypes}
\alias{getBroadSubtypes}
\title{Download expression-based cancer subtypes from the Broad Institute}
\usage{
getBroadSubtypes(dataset, clust.alg = c("CNMF", "ConsensusPlus"))
}
\arguments{
\item{dataset}{A TCGA cancer code, e.g. "OV" for ovarian cancer}

\item{clust.alg}{The selected cluster algorithm, either "CNMF" or
"ConsensusPlus" (default "CNMF")}
}
\value{
A \code{data.frame} of cluster and silhouette values
}
\description{
Obtain the mRNA expression clustering results from the
Broad Institute for a specific cancer code (see \link{getFirehoseDatasets}).
}
\examples{
co <- getBroadSubtypes("COAD", "CNMF")
head(co)

}
\author{
Ludwig Geistlinger
}
