% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SequenceData-end-pos.R
\docType{class}
\name{EndSequenceData-class}
\alias{EndSequenceData-class}
\alias{End5SequenceData}
\alias{End3SequenceData}
\alias{EndSequenceData}
\alias{End5SequenceDataFrame-class}
\alias{End5SequenceDataFrame}
\alias{End5SequenceData-class}
\alias{End3SequenceDataFrame-class}
\alias{End3SequenceDataFrame}
\alias{End3SequenceData-class}
\alias{EndSequenceDataFrame}
\alias{EndSequenceDataFrame-class}
\alias{getData,End5SequenceData,BamFileList,GRangesList,XStringSet,ScanBamParam-method}
\alias{getData,End3SequenceData,BamFileList,GRangesList,XStringSet,ScanBamParam-method}
\alias{getData,EndSequenceData,BamFileList,GRangesList,XStringSet,ScanBamParam-method}
\alias{aggregateData,End5SequenceData-method}
\alias{aggregateData,End3SequenceData-method}
\alias{aggregateData,EndSequenceData-method}
\alias{getDataTrack,EndSequenceData-method}
\alias{getDataTrack,End5SequenceData-method}
\alias{getDataTrack,End3SequenceData-method}
\title{End5SequenceData/End3SequenceData/EndSequenceData}
\usage{
End5SequenceDataFrame(
  df,
  ranges,
  sequence,
  replicate,
  condition,
  bamfiles,
  seqinfo
)

End3SequenceDataFrame(
  df,
  ranges,
  sequence,
  replicate,
  condition,
  bamfiles,
  seqinfo
)

EndSequenceDataFrame(
  df,
  ranges,
  sequence,
  replicate,
  condition,
  bamfiles,
  seqinfo
)

End5SequenceData(bamfiles, annotation, sequences, seqinfo, ...)

End3SequenceData(bamfiles, annotation, sequences, seqinfo, ...)

EndSequenceData(bamfiles, annotation, sequences, seqinfo, ...)

\S4method{getData}{End5SequenceData,BamFileList,GRangesList,XStringSet,ScanBamParam}(x, bamfiles, grl, sequences, param, args)

\S4method{getData}{End3SequenceData,BamFileList,GRangesList,XStringSet,ScanBamParam}(x, bamfiles, grl, sequences, param, args)

\S4method{getData}{EndSequenceData,BamFileList,GRangesList,XStringSet,ScanBamParam}(x, bamfiles, grl, sequences, param, args)

\S4method{aggregateData}{End5SequenceData}(x, condition = c("Both", "Treated", "Control"))

\S4method{aggregateData}{End3SequenceData}(x, condition = c("Both", "Treated", "Control"))

\S4method{aggregateData}{EndSequenceData}(x, condition = c("Both", "Treated", "Control"))

\S4method{getDataTrack}{EndSequenceData}(x, name, ...)

\S4method{getDataTrack}{End5SequenceData}(x, name, ...)

\S4method{getDataTrack}{End3SequenceData}(x, name, ...)
}
\arguments{
\item{df, ranges, sequence, replicate}{inputs for creating a 
\code{SequenceDataFrame}. See 
\code{\link[=SequenceDataFrame-class]{SequenceDataFrame}}.}

\item{condition}{For \code{\link{aggregate}}: condition for which the data
should be aggregated.}

\item{bamfiles, annotation, seqinfo, grl, sequences, param, args, ...}{See
\code{\link[=SequenceData-class]{SequenceData}} and
\code{\link[=SequenceData-functions]{SequenceData-functions}}}

\item{x}{a \code{End5SequenceData}, \code{End3SequenceData} or
\code{EndSequenceData} object}

\item{name}{For \code{\link[=plotDataByCoord]{getDataTrack}}: a valid
transcript name. Must be a name of \code{ranges(x).}}
}
\value{
a \code{End5SequenceData}, a \code{End3SequenceData} or a
\code{EndSequenceData} object
}
\description{
The \code{End5SequenceData}/\code{End3SequenceData}/\code{EndSequenceData}
classes aggregate the counts of read ends at each position along a
transcript. \code{End5SequenceData}/\code{End3SequenceData} classes aggregate
either the 5'-end or 3'-end, the \code{EndSequenceData} aggregates both.

All three classes contain one column per data file named using the following
naming convention \code{(end5/end3/end).condition.replicate}.

\code{aggregate} calculates the mean and sd for samples in the \code{control}
and \code{treated} condition separatly.
}
\examples{
# Construction of a End5SequenceData object
library(RNAmodR.Data)
library(rtracklayer)
annotation <- GFF3File(RNAmodR.Data.example.man.gff3())
sequences <- RNAmodR.Data.example.man.fasta()
files <- c(treated = RNAmodR.Data.example.wt.1())
e5sd <- End5SequenceData(files, annotation = annotation,
                        sequences = sequences)
}
