% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bounds.R
\name{a_high}
\alias{a_high}
\alias{a_low}
\alias{b_low}
\title{calculates bounds for modeled parameters}
\usage{
a_high(t_min)

a_low(t_max)

b_low(t_max)
}
\arguments{
\item{t_min}{time of first experiemtal time point after inhibition of
transcription (not T0)}

\item{t_max}{time of last experimental time point}
}
\value{
returns the lowest/highest parameter values to be used as bounds on
  modeled parameters
}
\description{
Calculates maximum and minimum bounds for parameter alpha based on experimental
  time points (t_0, t_1, t_2, t_3, ..., t_max). If RNA level is too low at t_1,
  then the decay has happened before our observations began - there is an upper
  bound to the decay rate we can detect (a_high).
If RNA level is too high at t_max, then relatively little decay has happened and
  we can not distinguish the decay rate and the decay of the decay rate  - there
  is a lower bound to the base decay rate of the decaying decay model (a_low).
}
\details{
Similarly, limits on beta are required to prevent precude ranges in which the
  decay rate and decaing decay are indistinguishable. See vignette
  "RNAdecay_workflow" for more information.
}
\examples{
a_high(7.5)
a_low(480)
b_low(480)
}
