% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RmbWorkspace.R
\docType{class}
\name{msmsWorkspace-class}
\alias{msmsWorkspace-class}
\alias{.msmsWorkspace}
\alias{show,msmsWorkspace-method}
\title{Workspace for \code{msmsWorkflow} data}
\usage{
\S4method{show}{msmsWorkspace}(object)
}
\arguments{
\item{object}{The \code{msmsWorkspace} to display.}
}
\description{
A workspace which stores input and output data for \code{\link{msmsWorkflow}}.
}
\details{
Slots:

 \describe{
	\item{files}{The input file names}
	\item{spectra}{The spectra per compound (\code{RmbSpectraSet}) extracted from the raw files}
 \item{aggregated}{A data.frame with an aggregated peak table from all \code{spectra}.
		Further columns are added during processing.}
 \item{rc, rc.ms1}{The recalibration curves generated in workflow step 4.}
 \item{parent}{For the workflow steps after 4: the parent workspace containing the state (spectra, aggregate)
		before recalibration, such that the workflow can be reprocessed from start.}
	\item{archivename}{The base name of the files the archive is stored to during the workflow.}
\item{settings}{The RMassBank settings used during the workflow, if stored with the workspace.}#' 
}

Methods: \describe{
	\item{show}{Shows a brief summary of the object and processing progress.}
	}
}
\seealso{
\code{\link{msmsWorkflow}}
}
\author{
Michael Stravs, Eawag <michael.stravs@eawag.ch>
}
