% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createCompoundlist.R
\name{CAS2SMILES}
\alias{CAS2SMILES}
\title{Convert CAS to SMILES}
\usage{
CAS2SMILES(CAS_number, name)
}
\arguments{
\item{CAS_number}{character
The CAS registry number of a compound}

\item{name}{character
The compound's name}
}
\value{
The SMILES code of the compound as character-string
}
\description{
This is a wrapper for \code{webchem::cir_query}, using the
CACTUS API at https://cactus.nci.nih.gov/chemical/structure_documentation
for the conversion. Before converting the CAS number, the 
name is checked whether it contains the word 'derivative'.
If so, the conversion is stopped and NA is returned.
Also, a warning will be printed in this case.
}
\details{
The API allows only one query per second. This is a hard-
coded feature
}
\examples{
SMILES_ethanol <- CAS2SMILES("64-17-5", "Ethanol")
}
\author{
pstahlhofen
}
