% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rjmcmcMethodsIntern.R
\name{postMerge}
\alias{postMerge}
\title{A internal post treatment function to merge closely positioned
nucleosomes, from the same chromosome,
identified by the \code{\link{rjmcmc}} function}
\usage{
postMerge(reads, resultRJMCMC, extendingSize, chrLength, minReads = 5,
  seqName = NULL)
}
\arguments{
\item{reads}{a \code{GRanges} containing all forward
and reverse reads.The start positions of both reads are going to be used
for the analysis. Beware that the start position of
a reverse read is always higher that the end positition.}

\item{resultRJMCMC}{an object of class 'rjmcmcNucleosomes' or
'rjmcmcNucleosomesMerge' containing informations about nucleosomes.}

\item{extendingSize}{a positive \code{numeric} or a positive \code{integer}
indicating the size of the consensus region used to group closeley
positioned nucleosomes.The minimum size of the consensus region is equal to
twice the value of the \code{extendingSize} parameter. The numeric will
be treated as an integer.}

\item{chrLength}{a positive \code{numeric} or a positive \code{integer}
indicating the lenght of the current chromosome. The length of the
chromosome is used to ensure that the consensus positions are all
located inside the chromosome.}

\item{minReads}{a positive \code{integer} or \code{numeric}, the minimum
number of reads in a potential canditate region. Non-integer values
of \code{minReads} will be casted to \code{integer} and truncated towards
zero. Default: 5.}
}
\value{
a \code{array} of \code{numeric}, the updated values of the
nucleosome positions. When no nucleosome is present, \code{NULL} is
returned.
}
\description{
A internal helper function which merges closely positioned
nucleosomes to rectify the over splitting and provide a more conservative
approach. Beware that each chromosome must be treated separatly.

The function uses the Bioconductor \code{package} \code{consensusSeeker} to
group closely positioned nucleosomes.
}
\examples{

## Loading dataset
data(RJMCMC_result)
data(reads_demo_02)

## Results before post-treatment
RJMCMC_result$mu

## Post-treatment function which merged closely positioned nucleosomes
postResult <- RJMCMCNucleosomes:::postMerge(reads = reads_demo_02,
resultRJMCMC = RJMCMC_result, extendingSize = 80, chrLength = 73500)

## Results after post-treatment
postResult

}
\author{
Pascal Belleau, Astrid Deschenes
}
\keyword{internal}
