% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lib_network.R
\name{readSIF}
\alias{readSIF}
\title{readSIF}
\usage{
readSIF(
  file = NA,
  header = FALSE,
  sep = "\\t",
  as.is = TRUE,
  p1 = 1,
  p2 = 2,
  et = 3,
  score = NA,
  ...
)
}
\arguments{
\item{file}{location of file}

\item{header}{indicator of presense of header on file}

\item{sep}{file delimiter - used by read.table()}

\item{as.is}{logical (default TRUE)}

\item{p1}{Column number for the 1st entity. Default = 1.}

\item{p2}{Column number for the 2nd entity. Default = 2.}

\item{et}{Column number for the edge type. Default = 3. Optionally, it may be a string label to be used as the edge type for all interactions from the input file.}

\item{score}{Column number for edge scores or weights. Default = NA (no score read).}

\item{...}{Other options to read.table().}
}
\value{
Returns a data.frame with 3 (or 4) columns of data.
}
\description{
This function reads a data table into R; the data table describes network interactions. It is named for the Simple Interaction Format (SIF), but can read any data table if the users identifies which columns contain the pertinent data (see below).
}
\details{
The SIF file format is a 3-column format, with an optional 4th column:
<entity-1><tab><edge-type><tab><entity-2><tab><score>

Entities may be genes, proteins, metabolites, etc. The edge type typically conveys the type of relationship that exists between the two entities, such as physical interaciton, phosphorylation, or activation.
}
\examples{
# Make a simple example to show the SIF file format
s <- matrix(c('gene1','gene2','PPI',
              'gene1','gene3','Chip-Seq',
              'gene4','gene5','PPI'), ncol=3, byrow=TRUE)
\dontrun{
# Read a SIF file
write.table( s, "myFile.sif", sep='\t', col.names=FALSE, row.names=FALSE )
sif <- readSIF("myFile.sif")
}
}
