% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lib_enrichment.R
\name{enrichment_symbols}
\alias{enrichment_symbols}
\title{enrichment_symbols}
\usage{
enrichment_symbols(geneset, term = NULL, all_symbols = NA, ...)
}
\arguments{
\item{geneset}{vector of gene symbols to be evaluated}

\item{term}{a list containing specific gene set term(s) and their corresponding gene symbols contained in one of the annotation resources, default is all gene set terms
in the GO, ReactomePathways, KEGG_filtered_canonical_pathways, and MSigDB_Hallmarks libraries}

\item{all_symbols}{gene symbols to be evaluated, identified by gene symbol name. Default is all protein coding genes. This parameter should be manipulated to include only the gene symbols that pertain to the user's analysis.}

\item{...}{additional arguments are not used}
}
\value{
results matrix of input gene list compared to active gene sets. Q value is calculated using entire group of active gene sets.
}
\description{
This function is called by term_enrichment() and term_enrichment_by_subset(). The user may call it directly, but we suggest using term_enrichment(). The function uses the resources currently loaded into the active_genesets vector. See load_geneset_symbols().
}
\details{
Outputs a data frame containing the gene set name, a hypergeometric-test p value, the number of genes from the
input gene list that occur in the gene set, the number of genes in the gene set, the gene symbols for
the genes in the input gene list, and the q value.
}
\examples{
require(RITANdata)
myGeneSet <- c('BRCA1','RAD51C','VAV1','HRAS','ABCC1','CYP1B1','CYP3A5')

\dontrun{
## We suggest using term_enrichment() instead. E.g.:
e <- term_enrichment(myGeneSet, 'GO')
}

## But, you may use enrichment_symbols() directly for an individual term:
load_geneset_symbols('GO')
e <- enrichment_symbols(myGeneSet, 'DNA_repair', all_symbols = cached_coding_genes)
print(e)

\dontrun{
## Gene set enrichment using intersection of gene symbols 
##   provided in geneset parameter and all protein coding genes.
enrichment_symbols(geneset = vac1.day0vs31.de.genes)

## choose which terms to evaluate
t <- active_genesets[1:5]

## Test enrichment of that set of terms
enrichment_symbols(geneset = vac1.day0vs31.de.genes, term = t)
}
}
